/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.CaretInfo;
import com.sun.jfx.incubator.scene.control.richtext.Origin;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.TextFlow;
import jfx.incubator.scene.control.richtext.TextPos;

public class CellArrangement {
    private final ArrayList<TextCell> cells = new ArrayList(32);
    private final double flowWidth;
    private final double flowHeight;
    private final int lineCount;
    private final double contentPaddingTop;
    private final double contentPaddingBottom;
    private final Origin origin;
    private int visibleCount;
    private int bottomCount;
    private double unwrappedWidth;
    private double topHeight;
    private double bottomHeight;
    private Node[] left;
    private Node[] right;

    public CellArrangement(VFlow vFlow, double d, double d2) {
        this.flowWidth = vFlow.getWidth();
        this.flowHeight = vFlow.getViewPortHeight();
        this.origin = vFlow.getOrigin();
        this.lineCount = vFlow.getParagraphCount();
        this.contentPaddingTop = d;
        this.contentPaddingBottom = d2;
    }

    public boolean isValid(VFlow vFlow, double d, double d2) {
        return vFlow.getWidth() == this.flowWidth && vFlow.getHeight() == this.flowHeight && vFlow.topCellIndex() == this.origin.index() && this.contentPaddingTop == d2 && this.contentPaddingBottom == this.contentPaddingBottom;
    }

    public String toString() {
        return "CellArrangement{origin=" + String.valueOf(this.origin) + ", topCount=" + this.topCount() + ", bottomCount=" + this.bottomCount + ", visible=" + this.getVisibleCellCount() + ", topHeight=" + this.topHeight + ", bottomHeight=" + this.bottomHeight + ", lineCount=" + this.lineCount + ", average=" + this.averageHeight() + ", unwrapped=" + this.getUnwrappedWidth() + "}";
    }

    public void addCell(TextCell textCell) {
        this.cells.add(textCell);
    }

    public void setUnwrappedWidth(double d) {
        this.unwrappedWidth = d;
    }

    public double getUnwrappedWidth() {
        return this.unwrappedWidth;
    }

    public int getVisibleCellCount() {
        return this.visibleCount;
    }

    public void setVisibleCellCount(int n) {
        this.visibleCount = n;
    }

    public TextPos getTextPos(double d, double d2) {
        int n;
        if (this.lineCount == 0) {
            return TextPos.ZERO;
        }
        int n2 = this.topIndex();
        int n3 = this.binarySearch(d2, n2, (n = this.bottomIndex()) - 1);
        TextCell textCell = this.getCell(n3);
        if (textCell != null) {
            Region region = textCell.getContent();
            double d3 = d2 - textCell.getY() - region.snappedTopInset();
            if (d3 < 0.0) {
                return TextPos.ofLeading(textCell.getIndex(), 0);
            }
            if (d3 < textCell.getCellHeight()) {
                if (region instanceof TextFlow) {
                    TextFlow textFlow = (TextFlow)region;
                    double d4 = d - textFlow.snappedLeftInset();
                    Point2D point2D = new Point2D(d4 - region.getLayoutX(), d3 - region.getLayoutY());
                    HitInfo hitInfo = textFlow.hitTest(point2D);
                    int n4 = hitInfo.getInsertionIndex();
                    int n5 = hitInfo.getCharIndex();
                    boolean bl = hitInfo.isLeading();
                    return new TextPos(textCell.getIndex(), n4, n5, bl);
                }
                return TextPos.ofLeading(textCell.getIndex(), 0);
            }
            int n6 = 0;
            if (region instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)region;
                n6 = RichUtils.getTextLength(textFlow);
            }
            return TextPos.ofLeading(textCell.getIndex(), n6);
        }
        return TextPos.ZERO;
    }

    public TextCell getCell(int n) {
        int n2 = n - this.origin.index();
        if (n2 < 0) {
            if (n2 + this.topCount() >= 0) {
                return this.cells.get(this.bottomCount - n2 - 1);
            }
        } else if (n2 < this.bottomCount) {
            return this.cells.get(n2);
        }
        return null;
    }

    public TextCell getVisibleCell(int n) {
        int n2 = n - this.origin.index();
        if (n2 >= 0 && n2 < this.visibleCount) {
            return this.cells.get(n2);
        }
        return null;
    }

    public TextCell getCellAt(int n) {
        if (n < this.visibleCount) {
            return this.cells.get(n);
        }
        return null;
    }

    public CaretInfo getCaretInfo(Region region, TextPos textPos) {
        boolean bl;
        int n;
        PathElement[] pathElementArray;
        int n2;
        TextCell textCell;
        if (textPos != null && (textCell = this.getCell(n2 = textPos.index())) != null && (pathElementArray = textCell.getCaretShape(region, n = textPos.charIndex(), bl = textPos.isLeading())) != null) {
            double d = textCell.getLineSpacing();
            return CaretInfo.create(d, pathElementArray);
        }
        return null;
    }

    public void removeNodesFrom(Pane pane) {
        ObservableList<Node> observableList = pane.getChildren();
        for (int i = this.getVisibleCellCount() - 1; i >= 0; --i) {
            TextCell textCell = this.cells.get(i);
            observableList.remove(textCell);
        }
    }

    public void setBottomCount(int n) {
        this.bottomCount = n;
    }

    public int bottomCount() {
        return this.bottomCount;
    }

    public int cellCount() {
        return this.cells.size();
    }

    public void setBottomHeight(double d) {
        this.bottomHeight = d;
    }

    public double bottomHeight() {
        return this.bottomHeight;
    }

    public int topCount() {
        return this.cells.size() - this.bottomCount;
    }

    public void setTopHeight(double d) {
        this.topHeight = d;
    }

    public double topHeight() {
        return this.topHeight;
    }

    public double averageHeight() {
        int n = this.cells.size();
        if (n == 0) {
            return 20.0;
        }
        return (this.topHeight + this.bottomHeight) / (double)n;
    }

    public double estimatedMax() {
        return (double)(this.lineCount - this.topCount() - this.bottomCount) * this.averageHeight() + this.topHeight + this.bottomHeight;
    }

    private int binarySearch(double d, int n, int n2) {
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            TextCell textCell = this.getCell(n3);
            int n4 = this.compare(textCell, d);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return n;
    }

    private int compare(TextCell textCell, double d) {
        double d2 = textCell.getY();
        if (d < d2) {
            return 1;
        }
        if (d >= d2 + textCell.getCellHeight()) {
            if (textCell.getIndex() == this.lineCount - 1) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public int topIndex() {
        return this.origin.index() - this.topCount();
    }

    public int bottomIndex() {
        return this.origin.index() + this.bottomCount;
    }

    public Origin moveOrigin(double d) {
        int n = this.topIndex();
        int n2 = this.bottomIndex();
        double d2 = d;
        if (d > 0.0) {
            double d3 = this.bottomHeight - this.flowHeight;
            if (d3 < 0.0) {
                return null;
            }
            if (d2 > d3) {
                d2 = d3;
            }
        }
        int n3 = this.binarySearch(d2, n, n2 - 1);
        TextCell textCell = this.getCell(n3);
        double d4 = d2 - textCell.getY();
        if (d < 0.0 && n3 == 0) {
            d4 = Math.max(d4, -this.contentPaddingTop);
        }
        return new Origin(textCell.getIndex(), d4);
    }

    public void addLeftNode(int n, Node node) {
        if (this.left == null) {
            this.left = new Node[this.visibleCount];
        }
        this.left[n] = node;
    }

    public void addRightNode(int n, Node node) {
        if (this.right == null) {
            this.right = new Node[this.visibleCount];
        }
        this.right[n] = node;
    }

    public Node getLeftNodeAt(int n) {
        return this.left[n];
    }

    public Node getRightNodeAt(int n) {
        return this.right[n];
    }

    private TextCell lastBottomCell() {
        if (this.bottomCount == 0) {
            return null;
        }
        return this.cells.get(this.bottomCount - 1);
    }
}

